/*
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright © 2024 Keith Packard
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LM32_SEMIHOST_H_
#define _LM32_SEMIHOST_H_

#include <stdint.h>

struct lm32_scall_args {
    uint32_t r8;
    uint32_t r1;
    uint32_t r2;
    uint32_t r3;
    uint32_t r4;
};

struct lm32_scall_ret {
    uint32_t r1;
    uint32_t r2;
    uint32_t r3;
};

void lm32_scall(const struct lm32_scall_args *args, struct lm32_scall_ret *ret);

void lm32_errno(int err);

#define TARGET_NEWLIB_SYS_argc              22
#define TARGET_NEWLIB_SYS_argn              24
#define TARGET_NEWLIB_SYS_argnlen           23
#define TARGET_NEWLIB_SYS_argv              13
#define TARGET_NEWLIB_SYS_argvlen           12
#define TARGET_NEWLIB_SYS_chdir             14
#define TARGET_NEWLIB_SYS_chmod             16
#define TARGET_NEWLIB_SYS_close             3
#define TARGET_NEWLIB_SYS_exit              1
#define TARGET_NEWLIB_SYS_fstat             10
#define TARGET_NEWLIB_SYS_getpid            8
#define TARGET_NEWLIB_SYS_gettimeofday      19
#define TARGET_NEWLIB_SYS_kill              9
#define TARGET_NEWLIB_SYS_link              21
#define TARGET_NEWLIB_SYS_lseek             6
#define TARGET_NEWLIB_SYS_open              2
#define TARGET_NEWLIB_SYS_read              4
#define TARGET_NEWLIB_SYS_reconfig          25
#define TARGET_NEWLIB_SYS_stat              15
#define TARGET_NEWLIB_SYS_time              18
#define TARGET_NEWLIB_SYS_times             20
#define TARGET_NEWLIB_SYS_unlink            7
#define TARGET_NEWLIB_SYS_utime             17
#define TARGET_NEWLIB_SYS_write             5

#define TARGET_NEWLIB_ERRNO_E2BIG           7
#define TARGET_NEWLIB_ERRNO_EACCES          13
#define TARGET_NEWLIB_ERRNO_EADDRINUSE      112
#define TARGET_NEWLIB_ERRNO_EADDRNOTAVAIL   125
#define TARGET_NEWLIB_ERRNO_EADV            68
#define TARGET_NEWLIB_ERRNO_EAFNOSUPPORT    106
#define TARGET_NEWLIB_ERRNO_EAGAIN          11
#define TARGET_NEWLIB_ERRNO_EALREADY        120
#define TARGET_NEWLIB_ERRNO_EBADE           50
#define TARGET_NEWLIB_ERRNO_EBADF           9
#define TARGET_NEWLIB_ERRNO_EBADFD          81
#define TARGET_NEWLIB_ERRNO_EBADMSG         77
#define TARGET_NEWLIB_ERRNO_EBADR           51
#define TARGET_NEWLIB_ERRNO_EBADRQC         54
#define TARGET_NEWLIB_ERRNO_EBADSLT         55
#define TARGET_NEWLIB_ERRNO_EBFONT          57
#define TARGET_NEWLIB_ERRNO_EBUSY           16
#define TARGET_NEWLIB_ERRNO_ECANCELED       140
#define TARGET_NEWLIB_ERRNO_ECHILD          10
#define TARGET_NEWLIB_ERRNO_ECHRNG          37
#define TARGET_NEWLIB_ERRNO_ECOMM           70
#define TARGET_NEWLIB_ERRNO_ECONNABORTED    113
#define TARGET_NEWLIB_ERRNO_ECONNREFUSED    111
#define TARGET_NEWLIB_ERRNO_ECONNRESET      104
#define TARGET_NEWLIB_ERRNO_EDEADLK         45
#define TARGET_NEWLIB_ERRNO_EDEADLOCK       56
#define TARGET_NEWLIB_ERRNO_EDESTADDRREQ    121
#define TARGET_NEWLIB_ERRNO_EDOM            33
#define TARGET_NEWLIB_ERRNO_EDOTDOT         76
#define TARGET_NEWLIB_ERRNO_EDQUOT          132
#define TARGET_NEWLIB_ERRNO_EEXIST          17
#define TARGET_NEWLIB_ERRNO_EFAULT          14
#define TARGET_NEWLIB_ERRNO_EFBIG           27
#define TARGET_NEWLIB_ERRNO_EFTYPE          79
#define TARGET_NEWLIB_ERRNO_EHOSTDOWN       117
#define TARGET_NEWLIB_ERRNO_EHOSTUNREACH    118
#define TARGET_NEWLIB_ERRNO_EIDRM           36
#define TARGET_NEWLIB_ERRNO_EILSEQ          138
#define TARGET_NEWLIB_ERRNO_EINPROGRESS     119
#define TARGET_NEWLIB_ERRNO_EINTR           4
#define TARGET_NEWLIB_ERRNO_EINVAL          22
#define TARGET_NEWLIB_ERRNO_EIO             5
#define TARGET_NEWLIB_ERRNO_EISCONN         127
#define TARGET_NEWLIB_ERRNO_EISDIR          21
#define TARGET_NEWLIB_ERRNO_EL2HLT          44
#define TARGET_NEWLIB_ERRNO_EL2NSYNC        38
#define TARGET_NEWLIB_ERRNO_EL3HLT          39
#define TARGET_NEWLIB_ERRNO_EL3RST          40
#define TARGET_NEWLIB_ERRNO_ELBIN           75
#define TARGET_NEWLIB_ERRNO_ELIBACC         83
#define TARGET_NEWLIB_ERRNO_ELIBBAD         84
#define TARGET_NEWLIB_ERRNO_ELIBEXEC        87
#define TARGET_NEWLIB_ERRNO_ELIBMAX         86
#define TARGET_NEWLIB_ERRNO_ELIBSCN         85
#define TARGET_NEWLIB_ERRNO_ELNRNG          41
#define TARGET_NEWLIB_ERRNO_ELOOP           92
#define TARGET_NEWLIB_ERRNO_EMFILE          24
#define TARGET_NEWLIB_ERRNO_EMLINK          31
#define TARGET_NEWLIB_ERRNO_EMSGSIZE        122
#define TARGET_NEWLIB_ERRNO_EMULTIHOP       74
#define TARGET_NEWLIB_ERRNO_ENAMETOOLONG    91
#define TARGET_NEWLIB_ERRNO_ENETDOWN        115
#define TARGET_NEWLIB_ERRNO_ENETRESET       126
#define TARGET_NEWLIB_ERRNO_ENETUNREACH     114
#define TARGET_NEWLIB_ERRNO_ENFILE          23
#define TARGET_NEWLIB_ERRNO_ENOANO          53
#define TARGET_NEWLIB_ERRNO_ENOBUFS         105
#define TARGET_NEWLIB_ERRNO_ENOCSI          43
#define TARGET_NEWLIB_ERRNO_ENODATA         61
#define TARGET_NEWLIB_ERRNO_ENODEV          19
#define TARGET_NEWLIB_ERRNO_ENOENT          2
#define TARGET_NEWLIB_ERRNO_ENOEXEC         8
#define TARGET_NEWLIB_ERRNO_ENOLCK          46
#define TARGET_NEWLIB_ERRNO_ENOLINK         67
#define TARGET_NEWLIB_ERRNO_ENOMEDIUM       135
#define TARGET_NEWLIB_ERRNO_ENOMEM          12
#define TARGET_NEWLIB_ERRNO_ENOMSG          35
#define TARGET_NEWLIB_ERRNO_ENONET          64
#define TARGET_NEWLIB_ERRNO_ENOPKG          65
#define TARGET_NEWLIB_ERRNO_ENOPROTOOPT     109
#define TARGET_NEWLIB_ERRNO_ENOSPC          28
#define TARGET_NEWLIB_ERRNO_ENOSR           63
#define TARGET_NEWLIB_ERRNO_ENOSTR          60
#define TARGET_NEWLIB_ERRNO_ENOSYS          88
#define TARGET_NEWLIB_ERRNO_ENOTBLK         15
#define TARGET_NEWLIB_ERRNO_ENOTCONN        128
#define TARGET_NEWLIB_ERRNO_ENOTDIR         20
#define TARGET_NEWLIB_ERRNO_ENOTEMPTY       90
#define TARGET_NEWLIB_ERRNO_ENOTRECOVERABLE 141
#define TARGET_NEWLIB_ERRNO_ENOTSOCK        108
#define TARGET_NEWLIB_ERRNO_ENOTSUP         134
#define TARGET_NEWLIB_ERRNO_ENOTTY          25
#define TARGET_NEWLIB_ERRNO_ENOTUNIQ        80
#define TARGET_NEWLIB_ERRNO_ENXIO           6
#define TARGET_NEWLIB_ERRNO_EOPNOTSUPP      95
#define TARGET_NEWLIB_ERRNO_EOVERFLOW       139
#define TARGET_NEWLIB_ERRNO_EOWNERDEAD      142
#define TARGET_NEWLIB_ERRNO_EPERM           1
#define TARGET_NEWLIB_ERRNO_EPFNOSUPPORT    96
#define TARGET_NEWLIB_ERRNO_EPIPE           32
#define TARGET_NEWLIB_ERRNO_EPROCLIM        130
#define TARGET_NEWLIB_ERRNO_EPROTO          71
#define TARGET_NEWLIB_ERRNO_EPROTONOSUPPORT 123
#define TARGET_NEWLIB_ERRNO_EPROTOTYPE      107
#define TARGET_NEWLIB_ERRNO_ERANGE          34
#define TARGET_NEWLIB_ERRNO_EREMCHG         82
#define TARGET_NEWLIB_ERRNO_EREMOTE         66
#define TARGET_NEWLIB_ERRNO_EROFS           30
#define TARGET_NEWLIB_ERRNO_ESHUTDOWN       110
#define TARGET_NEWLIB_ERRNO_ESOCKTNOSUPPORT 124
#define TARGET_NEWLIB_ERRNO_ESPIPE          29
#define TARGET_NEWLIB_ERRNO_ESRCH           3
#define TARGET_NEWLIB_ERRNO_ESRMNT          69
#define TARGET_NEWLIB_ERRNO_ESTALE          133
#define TARGET_NEWLIB_ERRNO_ESTRPIPE        143
#define TARGET_NEWLIB_ERRNO_ETIME           62
#define TARGET_NEWLIB_ERRNO_ETIMEDOUT       116
#define TARGET_NEWLIB_ERRNO_ETOOMANYREFS    129
#define TARGET_NEWLIB_ERRNO_ETXTBSY         26
#define TARGET_NEWLIB_ERRNO_EUNATCH         42
#define TARGET_NEWLIB_ERRNO_EUSERS          131
#define TARGET_NEWLIB_ERRNO_EWOULDBLOCK     11
#define TARGET_NEWLIB_ERRNO_EXDEV           18
#define TARGET_NEWLIB_ERRNO_EXFULL          52

#endif /* _LM32_SEMIHOST_H_ */
