/*
Copyright (c) 1991, 1993, 1994
The Regents of the University of California.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
 */
/*	$NetBSD: tdelete.c,v 1.2 1999/09/16 11:45:37 lukem Exp $	*/

/*
 * Tree search generalized from Knuth (6.2.2) Algorithm T just like
 * the AT&T man page says.
 *
 * The node_t structure is for internal use only, lint doesn't grok it.
 *
 * Written by reading the System V Interface Definition, not the code.
 *
 * Totally public domain.
 */

#if 0
#if defined(LIBC_SCCS) && !defined(lint)
#endif /* LIBC_SCCS and not lint */
#endif

#include <assert.h>
#define _SEARCH_PRIVATE
#include <search.h>
#include <stdlib.h>

/* delete node with given key */
void *
tdelete(const void * __restrict vkey, /* key to be deleted */
        void ** __restrict vrootp,    /* address of the root of tree */
        int (*compar)(const void *, const void *))
{
    node_t **rootp = (node_t **)vrootp;
    node_t  *p, *q, *r;
    int      cmp;

    if (rootp == NULL || (p = *rootp) == NULL)
        return NULL;

    while ((cmp = (*compar)(vkey, (*rootp)->key)) != 0) {
        p = *rootp;
        rootp = (cmp < 0) ? &(*rootp)->llink : /* follow llink branch */
            &(*rootp)->rlink;                  /* follow rlink branch */
        if (*rootp == NULL)
            return NULL; /* key not found */
    }
    r = (*rootp)->rlink;               /* D1: */
    if ((q = (*rootp)->llink) == NULL) /* Left NULL? */
        q = r;
    else if (r != NULL) {       /* Right link is NULL? */
        if (r->llink == NULL) { /* D2: Find successor */
            r->llink = q;
            q = r;
        } else { /* D3: Find NULL link */
            for (q = r->llink; q->llink != NULL; q = r->llink)
                r = q;
            r->llink = q->rlink;
            q->llink = (*rootp)->llink;
            q->rlink = (*rootp)->rlink;
        }
    }
    free(*rootp); /* D4: Free node */
    *rootp = q;   /* link parent to new node */
    return p;
}
